#!/usr/bin/env python
# -*- coding: utf-8 -*-

# LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


from plugins.events import EventPlugin
import dbus
import dbus.service


class MyPlugin(EventPlugin, dbus.service.Object):
	PLUGIN_ID = "LyricsScreenlet Informator"
	PLUGIN_NAME = _("LyricsScreenlet Informator")
	PLUGIN_VERSION = "1.0"
	PLUGIN_DESC = ("Extends default dbus interface, especialy to LyricsScreenlet communication.")
	
	song = None
		
	def __init__(self):
		EventPlugin.__init__(self)
		try:
			bus = dbus.SessionBus()
			name = dbus.service.BusName('org.LyricsScreenlet', bus=bus)
			path = '/org/LyricsScreenlet'
			dbus.service.Object.__init__(self, name, path)
		except Exception, e:
			print e
			pass
		
	@dbus.service.signal('org.LyricsScreenlet')
	def onSongChange(self, song):
		pass
		
	@dbus.service.signal('org.LyricsScreenlet')
	def onSeek(self, seek):
		pass
		
	@dbus.service.method('org.LyricsScreenlet')
	def currentSong(self):
		return self.song
		
	def plugin_on_song_started(self, song):
		#print "plugin: %s" % song
		#print "song: %s" % song._song['~filename']
		self.song = song._song['~filename']
		self.onSongChange(self.song)
		
	def plugin_on_seek(self, song, msec):
		#print "plugin seek: %s" % msec
		self.onSeek(msec/1000.0)
		
